<?php
/*#################################################################################
	AdLogger
	- An open-source tracking tool for preventing click fraud

	Copyright 2006 by Trevor Fitzgerald
	http://www.adlogger.org

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

	If you find this script useful, please share it with others!

	Thank you!
*/#################################################################################

// Include the configuration files.
require ("../config_database.php");
require ("../config_settings.php");
require ("../config_admin.php");

// Make sure the person is logged in.
require ("./loginverify.php");

/*
 * Include the functions. Start the page timer, output the opening HTML,
 * and verify that we can actually connect to the database.
*/
require ("./functions.php");
	$start_time = micro_time(0);
	bodyHeader('rankings', $version_num);
	bodyNavigation('rankings');
	check_db_connection($adlogger_db_connect, $adlogger_db_select);

if (isset($_GET['rows_per_page']) && !empty($_GET['rows_per_page'])) {
	$rows_per_page = $_GET['rows_per_page'];
	$view_criteria = $_GET['view_criteria'];
	$view_order = $_GET['view_order'];
} else {
	$rows_per_page = 10;
	$view_criteria = 'disp_url';
	$view_order = 'DESC';
}

if (isset($_GET['view_date']) && !empty($_GET['view_date'])) {

	if ($view_criteria == 'dates' || $view_criteria == 'days' || $view_criteria == 'months' || $view_criteria == 'months_alltime') {
		echo '<div id="main-copy">
				<h1>Error!</h1>
				<p>When sorting by date values, please leave the calendar field blank.</p>
				<p>Please go back and try again.</p>
			</div>';
		bodyFooter('error', $start_time);
		exit();
	}

	$view_date = $_GET['view_date'];
	$view_date_begin_timestamp = strtotime($view_date);
	$view_date_end_timestamp = $view_date_begin_timestamp + (24*60*60);
	$where_query = "WHERE " . $db_table_prefix . "logfiles.timestamp >= $view_date_begin_timestamp AND " . $db_table_prefix . "logfiles.timestamp < $view_date_end_timestamp";
} else {
	$view_date = '';
	$where_query = '';
}

// For pagination, we need to know what page we're trying to access
if (isset($_GET['pageno']) && !empty($_GET['pageno'])) {
   $pageno = $_GET['pageno'];
} else {
   $pageno = 1;
}
?>

<div id="side-bar">
	<div>
		<p class="sideBarTitle">Performance Data</p>
		<ul>
			<li><a href="#rank_prefs">&rsaquo; Rankings Preferences</a></li>
			<li><a href="#rank_data">&rsaquo; Ranking Data</a></li>
		</ul>
	</div>
</div>

<div id="main-copy">
	<h1 id="rank_prefs">Rankings Preferences</h1>

	<br />

	<form name="view_preferences" action="<?php echo $_SERVER['PHP_SELF']; ?>" method="get" onsubmit="return validate_date(this);">
		<fieldset>

			<legend>Ranking View Preferences</legend>
			<div align="center">
				View 
				<select name="rows_per_page">
					<option value="10"<?php select_item_if_chosen('10', $rows_per_page); ?>>10</option>
					<option value="25"<?php select_item_if_chosen('25', $rows_per_page); ?>>25</option>
					<option value="50"<?php select_item_if_chosen('50', $rows_per_page); ?>>50</option>
				</select>
				<select name="view_criteria">
					<option disabled="disabled">Click Data</option>
						<option value="disp_url"<?php select_item_if_chosen('disp_url', $view_criteria); ?>>Pages</option>
						<option value="ch_id"<?php select_item_if_chosen('ch_id', $view_criteria); ?>>Channels</option>
						<option value="visitor_ip"<?php select_item_if_chosen('visitor_ip', $view_criteria); ?>>Visitors</option>
						<option value="ref"<?php select_item_if_chosen('ref', $view_criteria); ?>>Referrers</option>
					<option disabled="disabled">Time Periods</option>
						<option value="hours_day"<?php select_item_if_chosen('hours_day', $view_criteria); ?>>Hours of the day</option>
						<option value="dates"<?php select_item_if_chosen('dates', $view_criteria); ?>>  Dates</option>
						<option value="days"<?php select_item_if_chosen('days', $view_criteria); ?>>Days (Sun-Sat)</option>
						<option value="months"<?php select_item_if_chosen('months', $view_criteria); ?>>Months (Jan-Dec)</option>
						<option value="months_alltime"<?php select_item_if_chosen('months_alltime', $view_criteria); ?>>Months (All-time)</option>
					<option disabled="disabled">Ad Attributes</option>
						<option value="group_attributes"<?php select_item_if_chosen('group_attributes', $view_criteria); ?>>Ad Designs</option>
						<option value="targ_url"<?php select_item_if_chosen('targ_url', $view_criteria); ?>>Target Ads</option>
						<option value="format"<?php select_item_if_chosen('format', $view_criteria); ?>>Ad Formats</option>
						<option value="color_bg"<?php select_item_if_chosen('color_bg', $view_criteria); ?>>Background Colors</option>
						<option value="color_txt"<?php select_item_if_chosen('color_txt', $view_criteria); ?>>Text Colors</option>
						<option value="color_lnk"<?php select_item_if_chosen('color_lnk', $view_criteria); ?>>Link Colors</option>
						<option value="color_url"<?php select_item_if_chosen('color_url', $view_criteria); ?>>URL Colors</option>
						<option value="color_brd"<?php select_item_if_chosen('color_brd', $view_criteria); ?>>Border Colors</option>
						<option value="ad_type"<?php select_item_if_chosen('ad_type', $view_criteria); ?>>Ad Types</option>
				</select>
				with the 
				<select name="view_order">
					<option value="DESC"<?php select_item_if_chosen('DESC', $view_order); ?>>Most</option>
					<option value="ASC"<?php select_item_if_chosen('ASC', $view_order); ?>>Least</option>
				</select>
				amount of clicks for 
				<input name="view_date" type="text" onfocus="showCalendarControl(this);" value="<?php echo $view_date; ?>" size="10">
				.
				<input type="submit" value="Sort" />
				<br /><br />
				* Leave date blank to search all records.
				<br /><br />
				* "Least" does not include criteria with 0 clicks because they don't exist in the database yet.
			</div>
			
		</fieldset>
	</form>

	<h1 id="rank_data">Rankings Data</h1>

	<br />

	<?php

	/*
	These are the pagination queries.  We have to determine how many results there are
	in order to disperse them among different pages.
	*/
	if ($view_criteria == 'ch_id') {
			/*
			 * If the user is trying to sort by adlogger channels,
			 * do a count to see how many unique channels are actually
			 * present in the log files.
			 */
			$sql = "SELECT COUNT(DISTINCT ch_id)
						FROM " . $db_table_prefix . "logfiles
							$where_query
								";
				$result = mysql_query($sql);
					$row = mysql_fetch_array($result);
						$numrows = $row['COUNT(DISTINCT ch_id)'];

	} elseif ($view_criteria == 'dates') {
			/*
			 * If the user is trying to sort by dates,
			 * do a count to see how many unique dates are actually
			 * present in the log files.
			 */
			$sql = "SELECT COUNT(DISTINCT DATE(FROM_UNIXTIME(timestamp))) AS distinctDates
						FROM " . $db_table_prefix . "logfiles
							";

				$result = mysql_query($sql);
					$row = mysql_fetch_array($result);
						$numrows = $row['distinctDates'];

	} elseif ($view_criteria == 'days') {
			/*
			 * If the user is trying to sort by days (Sun-Sat),
			 * we know it can not exceed 7, so do not bother
			 * performing a query to count.
			 */
			$numrows = 7;

	} elseif ($view_criteria == 'hours_day') {
			/*
			 * If the user is trying to sort by hours,
			 * do a count to see how many unique hours are actually
			 * present in the log files.
			 */
			$sql = "SELECT COUNT(DISTINCT HOUR(FROM_UNIXTIME(timestamp))) AS distinctHours
						FROM " . $db_table_prefix . "logfiles
							$where_query
								";

				$result = mysql_query($sql);
					$row = mysql_fetch_array($result);
						$numrows = $row['distinctHours'];

	} elseif ($view_criteria == 'months') {
			/*
			 * If the user is trying to sort by months,
			 * do a count to see how many unique months are actually
			 * present in the log files.
			 */
			$sql = "SELECT COUNT(DISTINCT MONTHNAME(FROM_UNIXTIME(timestamp))) AS distinctMonth
						FROM " . $db_table_prefix . "logfiles
							";

				$result = mysql_query($sql);
					$row = mysql_fetch_array($result);
						$numrows = $row['distinctMonth'];

	} elseif ($view_criteria == 'months_alltime') {
			/*
			 * If the user is trying to sort by all time months,
			 * do a count to see how many distinct and unique months
			 * are actually present in the log files.
			 */
			$sql = "SELECT YEAR(FROM_UNIXTIME(timestamp)) AS year, MONTHNAME(FROM_UNIXTIME(timestamp)) AS month, COUNT(*) AS instance_count
						FROM " . $db_table_prefix . "logfiles
							GROUP BY year, month
								";

				$result = mysql_query($sql);
					$numrows = mysql_num_rows($result);

	} elseif ($view_criteria == 'group_attributes') {
			/*
			 * If the user is trying to sort by grouped attributes,
			 * do a count to see how many distinct and unique ad units
			 * are actually present in the log files.
			 */
			$sql = "SELECT format, color_bg, color_txt, color_lnk, color_url, color_brd, ad_type
						FROM " . $db_table_prefix . "logfiles
							GROUP BY format, color_bg, color_txt, color_lnk, color_url, color_brd, ad_type
								";

				$result = mysql_query($sql);
					$numrows = mysql_num_rows($result);

	} else {
			/*
			 * Otherwise, just perform a query counting the number
			 * of instances the view criteria appear in the log files.
			 * The simplest query of them all.
			 */
			$sql = "SELECT COUNT(DISTINCT " . $view_criteria . ") AS distinct_count
						FROM " . $db_table_prefix . "logfiles
							$where_query
								";

				$result = mysql_query($sql);
					$row = mysql_fetch_array($result);
						$numrows = $row['distinct_count'];

	}

			$lastpage = ceil($numrows/$rows_per_page);
			if ($lastpage == 0) $lastpage = 1;

			$pageno = (int)$pageno;

			$limit = 'LIMIT ' .($pageno - 1) * $rows_per_page .',' .$rows_per_page;

			echo "<div align=\"center\">";
				if ($pageno <= 1) {
					echo " FIRST PREV ";
				} else {
					echo " <a href='{$_SERVER['PHP_SELF']}?pageno=1&amp;rows_per_page=$rows_per_page&amp;view_criteria=$view_criteria&amp;view_order=$view_order&amp;view_date=$view_date#rank_data'>FIRST</a> ";
					$prevpage = $pageno - 1;
					echo " <a href='{$_SERVER['PHP_SELF']}?pageno=$prevpage&amp;rows_per_page=$rows_per_page&amp;view_criteria=$view_criteria&amp;view_order=$view_order&amp;view_date=$view_date#rank_data'>PREV</a> ";
				}

				echo " ( Page $pageno of $lastpage ) ";

				if ($pageno >= $lastpage) {
					echo " NEXT LAST ";
				} else {
					$nextpage = $pageno + 1;
					echo " <a href='{$_SERVER['PHP_SELF']}?pageno=$nextpage&amp;rows_per_page=$rows_per_page&amp;view_criteria=$view_criteria&amp;view_order=$view_order&amp;view_date=$view_date#rank_data'>NEXT</a> ";
					echo " <a href='{$_SERVER['PHP_SELF']}?pageno=$lastpage&amp;rows_per_page=$rows_per_page&amp;view_criteria=$view_criteria&amp;view_order=$view_order&amp;view_date=$view_date#rank_data'>LAST</a> ";
				}
			echo "</div><br />";

	/*
	If there's nothig to display, don't bother showing the table.
	*/
	if ($numrows == 0) {
		echo "<strong>No values match the specified criteria.</strong></div>";
		bodyFooter('rankings', $start_time);
		exit();
	}

	?>

	<?php
	/*
	 * Let's test which of those queries we need to perform...
	 * This is for sorting by the custom adlogger channels.
	*/
	if ($view_criteria == 'ch_id') { ?>

			<table summary="rankings_list" width="100%" id="greytable">

				<thead id="greythead">
					<tr>
						<th scope="col">AdLogger Channel</th>
						<th scope="col">Clicks</th>
					</tr>
				</thead>

				<tbody id="greytbody">

						<?php
							/*
							 * Perform the query on the database to grab the rows.
							 * This is one of the most complex queries I have ever written.
							*/
							$sql = "SELECT " . $db_table_prefix . "channels.chan_name AS channel_name, COUNT(" . $db_table_prefix . "logfiles.ch_id) AS instance_count
										FROM " . $db_table_prefix . "logfiles
											LEFT JOIN  " . $db_table_prefix . "channels
												ON " . $db_table_prefix . "logfiles.ch_id = " . $db_table_prefix . "channels.id
													$where_query
														GROUP BY   " . $db_table_prefix . "logfiles.ch_id
															ORDER BY instance_count " . $view_order . "
																$limit
																	";

								$result = mysql_query($sql) or die(mysql_error());
									/*
									Start the loop to display them.  In this loop, the script creates
									a new table row for each entry it finds from the database.
									*/
									while($row = mysql_fetch_array($result)) {
										$channel_name = $row['channel_name'];
										$instance_count = $row['instance_count'];
								?>

										<tr class="odd">
										<td><?php echo unset_if_string_empty($channel_name); ?></td>
										<td><?php echo $instance_count; ?></td>
										</tr>

								<?php } /* End the loop. */ ?>

				</tbody>

			</table>

	<?php
	/*
	 * This is for sorting by individual dates
	*/
	} elseif ($view_criteria == 'dates') { ?>

			<table summary="rankings_list" width="100%" id="greytable">

				<thead id="greythead">
					<tr>
						<th scope="col">Date</th>
						<th scope="col">Clicks</th>
					</tr>
				</thead>

				<tbody id="greytbody">
						<?php
							/*
							Perform the query on the database to grab the rows.
							*/
							$sql = "SELECT DATE(FROM_UNIXTIME(timestamp)) AS date, COUNT(*) AS instance_count
										FROM " . $db_table_prefix . "logfiles
											GROUP BY date
												ORDER BY instance_count " . $view_order . "
													$limit
														";

								$result = mysql_query($sql) or die(mysql_error());
									/*
									Start the loop to display them.  In this loop, the script creates
									a new table row for each entry it finds from the database.
									*/
										while($row = mysql_fetch_array($result)) {
											$date = $row['date'];
												/*
												The "$date" is given in YYYY-MM-DD format.
												Let's convert it to something more readable.
												*/
												$date = date('D, M j, Y', strtotime($date));
											$instance_count = $row['instance_count'];
						?>
											<tr class="odd">
												<td><?php echo unset_if_string_empty($date); ?></td>
												<td><?php echo $instance_count; ?></td>
											</tr>

									<?php } /* End the loop. */ ?>
				</tbody>

			</table>

	<?php
	/*
	 * This is for sorting by days (Sun-Sat)
	*/
	} elseif ($view_criteria == 'days') { ?>

			<table summary="rankings_list" width="100%" id="greytable">

				<thead id="greythead">
					<tr>
						<th scope="col">Day</th>
						<th scope="col">Clicks</th>
					</tr>
				</thead>

				<tbody id="greytbody">
						<?php
							/*
							Perform the query on the database to grab the rows.
							*/
							$sql = "SELECT DAYOFWEEK(FROM_UNIXTIME(timestamp)) AS day, COUNT(*) AS instance_count
										FROM " . $db_table_prefix . "logfiles
											GROUP BY day
												ORDER BY instance_count " . $view_order . "
													$limit
														";

								$result = mysql_query($sql) or die(mysql_error());
									/*
									Start the loop to display them.  In this loop, the script creates
									a new table row for each entry it finds from the database.
									*/
										while($row = mysql_fetch_array($result)) {
											$day = $row['day'];
												/*
												 * Figure out the corresponding day
												 * from its numerical representation
												 */
												if ($day == 1) {
													$day = 'Sunday';
												} elseif ($day == 2) {
													$day = 'Monday';
												} elseif ($day == 3) {
													$day = 'Tuesday';
												} elseif ($day == 4) {
													$day = 'Wednesday';
												} elseif ($day == 5) {
													$day = 'Thursday';
												} elseif ($day == 6) {
													$day = 'Friday';
												} elseif ($day == 7) {
													$day = 'Saturday';
												}
											$instance_count = $row['instance_count'];
						?>
											<tr class="odd">
												<td><?php echo $day; ?></td>
												<td><?php echo $instance_count; ?></td>
											</tr>

									<?php } /* End the loop. */ ?>
				</tbody>

			</table>

	<?php
	/*
	 * This is for sorting by hours of the day (0-23)
	*/
	} elseif ($view_criteria == 'hours_day') { ?>

			<table summary="rankings_list" width="100%" id="greytable">

				<thead id="greythead">
					<tr>
						<th scope="col">Hour</th>
						<th scope="col">Clicks</th>
					</tr>
				</thead>

				<tbody id="greytbody">
						<?php
							/*
							Perform the query on the database to grab the rows.
							*/
							$sql = "SELECT HOUR(FROM_UNIXTIME(timestamp)) AS hour, COUNT(*) AS instance_count
										FROM " . $db_table_prefix . "logfiles
											$where_query
												GROUP BY hour
													ORDER BY instance_count " . $view_order . "
														$limit
															";

								$result = mysql_query($sql) or die(mysql_error());
									/*
									Start the loop to display them.  In this loop, the script creates
									a new table row for each entry it finds from the database.
									*/
										while($row = mysql_fetch_array($result)) {
											$hour = $row['hour'];
											$instance_count = $row['instance_count'];
						?>
											<tr class="odd">
												<td><?php echo convertHour($hour) . ' - ' . convertHour($hour + 1); ?></td>
												<td><?php echo $instance_count; ?></td>
											</tr>

									<?php } /* End the loop. */ ?>
				</tbody>

			</table>

	<?php
	/*
	 * This is for sorting click by month (1-12)
	*/
	} elseif ($view_criteria == 'months') { ?>

			<table summary="rankings_list" width="100%" id="greytable">

				<thead id="greythead">
					<tr>
						<th scope="col">Month</th>
						<th scope="col">Clicks</th>
					</tr>
				</thead>

				<tbody id="greytbody">
						<?php
							/*
							Perform the query on the database to grab the rows.
							*/
							$sql = "SELECT MONTHNAME(FROM_UNIXTIME(timestamp)) AS month, COUNT(*) AS instance_count
										FROM " . $db_table_prefix . "logfiles
											GROUP BY month
												ORDER BY instance_count " . $view_order . "
													$limit
														";

								$result = mysql_query($sql) or die(mysql_error());
									/*
									Start the loop to display them.  In this loop, the script creates
									a new table row for each entry it finds from the database.
									*/
										while($row = mysql_fetch_array($result)) {
											$month = $row['month'];
											$instance_count = $row['instance_count'];
						?>
											<tr class="odd">
												<td><?php echo $month; ?></td>
												<td><?php echo $instance_count; ?></td>
											</tr>

									<?php } /* End the loop. */ ?>
				</tbody>

			</table>

	<?php
	/*
	 * This is for sorting by months of all time.
	 * It sorts by month and year.
	*/
	} elseif ($view_criteria == 'months_alltime') { ?>

			<table summary="rankings_list" width="100%" id="greytable">

				<thead id="greythead">
					<tr>
						<th scope="col">Month and Year</th>
						<th scope="col">Clicks</th>
					</tr>
				</thead>

				<tbody id="greytbody">
						<?php
							/*
							Perform the query on the database to grab the rows.
							*/
							$sql = "SELECT YEAR(FROM_UNIXTIME(timestamp)) AS year, MONTHNAME(FROM_UNIXTIME(timestamp)) AS month, COUNT(*) AS instance_count
										FROM " . $db_table_prefix . "logfiles
											GROUP BY year, month
												ORDER BY instance_count " . $view_order . "
													$limit
														";

								$result = mysql_query($sql) or die(mysql_error());
									/*
									Start the loop to display them.  In this loop, the script creates
									a new table row for each entry it finds from the database.
									*/
										while($row = mysql_fetch_array($result)) {
											$year = $row['year'];
											$month = $row['month'];
											$instance_count = $row['instance_count'];
						?>
											<tr class="odd">
												<td><?php echo $month . " " . $year; ?></td>
												<td><?php echo $instance_count; ?></td>
											</tr>

									<?php } /* End the loop. */ ?>
				</tbody>

			</table>

	<?php
	/*
	 * This is for sorting by months of all time.
	 * It sorts by month and year.
	*/
	} elseif ($view_criteria == 'group_attributes') { ?>

			<table summary="rankings_list" width="100%" id="greytable">

				<thead id="greythead">
					<tr>
						<th scope="col" width="12.5%">Ad Width</th>
						<th scope="col" width="12.5%">Ad Height</th>
						<th scope="col" width="10%">BG Color</th>
						<th scope="col" width="10%">Text Color</th>
						<th scope="col" width="10%">Link Color</th>
						<th scope="col" width="10%">URL Color</th>
						<th scope="col" width="10%">Border Color</th>
						<th scope="col" width="10%">Ad Type</th>
						<th scope="col" width="15%">Clicks</th>
					</tr>
				</thead>

				<tbody id="greytbody">
						<?php
							/*
							Perform the query on the database to grab the rows.
							*/
							$sql = "SELECT format, color_bg, color_txt, color_lnk, color_url, color_brd, ad_type, COUNT(*) AS instance_count
										FROM " . $db_table_prefix . "logfiles
											GROUP BY format, color_bg, color_txt, color_lnk, color_url, color_brd, ad_type
												ORDER BY instance_count " . $view_order . "
													$limit
														";

								$result = mysql_query($sql) or die(mysql_error());
									/*
									Start the loop to display them.  In this loop, the script creates
									a new table row for each entry it finds from the database.
									*/
										while($row = mysql_fetch_array($result)) {
											$format = $row['format'];
												$ad_width = convertAdFormat($format, 'width');
												$ad_height = convertAdFormat($format, 'height');
											$color_bg = $row['color_bg'];
											$color_txt = $row['color_txt'];
											$color_lnk = $row['color_lnk'];
											$color_url = $row['color_url'];
											$color_brd = $row['color_brd'];
											$ad_type = $row['ad_type'];
											$instance_count = $row['instance_count'];
						?>
											<tr class="odd">
												<td><?php echo $ad_width; ?></td>
												<td><?php echo $ad_height; ?></td>
												<td><?php echo $color_bg . draw_color($color_bg, $gd_enabled); ?></td>
												<td><?php echo $color_txt . draw_color($color_txt, $gd_enabled); ?></td>
												<td><?php echo $color_lnk . draw_color($color_lnk, $gd_enabled); ?></td>
												<td><?php echo $color_url . draw_color($color_url, $gd_enabled); ?></td>
												<td><?php echo $color_brd . draw_color($color_brd, $gd_enabled); ?></td>
												<td><?php echo ucfirst(str_replace('_i', '/I', $ad_type)); ?></td>
												<td><?php echo $instance_count; ?></td>
											</tr>

									<?php } /* End the loop. */ ?>
				</tbody>

			</table>

	<?php
	/*
	 * This is for sorting by any of the other criteria.
	*/
	} else { ?>

			<table summary="rankings_list" width="100%" id="greytable">

				<thead id="greythead">
					<tr>
						<th scope="col">Criteria</th>
						<th scope="col">Clicks</th>
					</tr>
				</thead>

				<tbody id="greytbody">

						<?php
							/*
							Perform the query on the database to grab the rows.
							*/
							$sql = "SELECT " . $view_criteria . ", COUNT(" . $view_criteria . ") AS instance_count
										FROM " . $db_table_prefix . "logfiles
											$where_query
												GROUP BY " . $view_criteria . "
													ORDER BY instance_count " . $view_order . "
														$limit
															";

								$result = mysql_query($sql) or die(mysql_error());
									/*
									Start the loop to display them.  In this loop, the script creates
									a new table row for each entry it finds from the database.
									*/
									while($row = mysql_fetch_array($result)) {
										$view_criteria_name = $row["$view_criteria"];
										$instance_count = $row['instance_count'];
						?>

										<tr class="odd">
											<td>
												<?php
													if (($view_criteria == 'disp_url') || ($view_criteria == 'ref')) {
														echo shortenURL($view_criteria_name);
													} elseif ($view_criteria == 'format') {
														echo convertAdFormat($view_criteria_name, 'width') . "x" . convertAdFormat($view_criteria_name, 'height') . " - " . translateAdFormat($view_criteria_name);
													} elseif (strstr($view_criteria, 'color')) {
														echo $view_criteria_name . draw_color($view_criteria_name, $gd_enabled);
													} elseif ($view_criteria == 'ad_type') {
														echo ucfirst(str_replace('_i', '/I', $view_criteria_name));
													} else {
														echo unset_if_string_empty($view_criteria_name);
													}
												?>
											</td>
											<td><?php echo $instance_count; ?></td>
										</tr>

									<?php } /* End the loop. */ ?>

				</tbody>

			</table>

	<?php
	// End the check of which table to show.
	}
	?>

</div>

<?php bodyFooter('rankings', $start_time); ?>